<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentSubscribe extends Model
{
    use HasFactory;


    public function room()
    {
        return $this->belongsTo(ClassRoom::class,'room_id');
    }

    public function student()
    {
        return $this->belongsTo(User::class,'student_id');
    }

    public function attendances()
    {
        return $this->hasMany(Attendance::class,'subscribe_id');
    }

    public function uploadedAnswers()
    {
        return $this->hasMany(UploadedExam::class,'subscribe_id');
    }

    public function uploadedEvaluations()
    {
        return $this->hasMany(UploadedEvaluation::class,'subscribe_id');
    }

    public function evaluation()
    {
        return $this->hasMany(SubscriberEvaluation::class,'subscribe_id');
    }
}
